@ECHO OFF

SET PROJECT=TCSafeRun
SET DELPHI=C:\Software\Programming\Delphi XE3
SET DCC_OPT1=--no-config -E.\bin -M -NU.\dcu -O.\obj -U"%DELPHI%\Lib"
SET DCC_OPT2=-W-GARBAGE -W-UNSAFE_TYPE -W-UNSAFE_CODE -W-UNSAFE_CAST -$D- -$L- -$Y-
SET DCC_CMD="%DELPHI%\Bin\DCC32.exe" %DCC_OPT1% %DCC_OPT2%
SET TASM_CMD="%DELPHI%\Bin\TAsm32.exe" /ml /q /m
SET MINBIN_CMD="%DELPHI%\Tools\MinBin.exe" /HEAP:4096,65536 /VERSION:1.00

TITLE %PROJECT%

:menu
CLS
ECHO.
ECHO  B. Build project
ECHO.
ECHO  S. Shrink binary
ECHO.
ECHO  A. Compile "Main.asm"
ECHO.
ECHO  X. Exit

Choice.exe /C:BSAX /N
CLS
IF %ERRORLEVEL%==1 GOTO runB
IF %ERRORLEVEL%==2 GOTO runS
IF %ERRORLEVEL%==3 GOTO runA
IF %ERRORLEVEL%==4 EXIT

:runB
%DCC_CMD% %PROJECT%.dpr
ECHO.
PAUSE
GOTO menu

:runS
%MINBIN_CMD% .\bin\%PROJECT%.exe
TITLE %PROJECT%
GOTO menu

:runA
IF EXIST "%DELPHI%\Bin\TAsm32.bin" (
	%TASM_CMD% Main.asm .\obj\*
	PAUSE
) ELSE (
	ECHO.
	ECHO  To compile this file you need special version of Turbo Assembler!
	ECHO.
	PAUSE
)
GOTO menu
